<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $occorrenza = $geecomDb->leggiSingolaRiga("geec_condivisioniFile",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom Doc - creazione condivisione file</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formElemento" action="controller/controllerCondivisioniFile.php" method="post">
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==210) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Video duplicato, modificalo per non avere due video uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        
                        <div class="col-12">
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Condivisione file</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($occorrenza)? $occorrenza["nome"] : "Nuovo video"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                    <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    <?php 
                                        if(isset($occorrenza)) {
                                    ?>
                                        <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerVideo.php?id=<?php echo $occorrenza["id"] ?>&operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                    <?php
                                        }
                                    ?>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                    <input type="text" class="d-none" name="operazione" value="<?php echo((isset($occorrenza) ? "modifica" : "crea")); ?>">
                                    <input type="text" class="d-none" name="id" value="<?php echo((isset($occorrenza) ? $occorrenza["id"] : "0")); ?>">

                                    <div class="card-body">
                                        <div class="row">
                                            
                                            <div class="col-lg-12">
                                                <div class="row">
                                                    <div class="col-md-6 col-lg-3 form-group">
                                                        <label>Nome</label>
                                                        <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome" value="<?php echo((isset($occorrenza) ? $occorrenza["nome"] : "")) ?>" placeholder="Nome">
                                                    </div>
                                                    
                                                    <div class="col-md-6 col-lg-3 form-group">
                                                        <label>Contenuto da condividere</label>
                                                        <select class="form-control" name="contenutoDaCondividere" id="contenutoDaCondividere" onchange="mostraSelectInRelazioneAlContenutoCondiviso()">
                                                        <?php 
                                                            $tipiContenuti = ["file","cartella"];
                                                            foreach($tipiContenuti as $tipo) {
                                                                if(isset($occorrenza) && $occorrenza["contenutoDaCondividere"]==$tipo) {
                                                                    echo"<option value=\"$tipo\" selected>$tipo</option>";
                                                                }
                                                                else {
                                                                    echo"<option value=\"$tipo\">$tipo</option>";
                                                                }
                                                            }
                                                        ?>
                                                        </select>
                                                        <small class="text-muted">Scegli lo spazio che deve occupare il video nella sezione</small>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-6 col-lg-3">
                                                        <label for="titolo-articolo">Termine condivisione</label>
                                                        <input  type="date" class="form-control" name="termineCondivisione" value="<?php echo((isset($occorrenza)? $occorrenza["termineCondivisione"] : ""))?>">
                                                        <small class="text-muted">La data in cui terminerà la condivisione (chi visiterà il link non sarà più in grado di scaricare il file)</small>
                                                    </div>
                                                    
                                                    <div id="divSelezionaCartella" class="<?= ($occorrenza["contenutoDaCondividere"]=="cartella") ? "form-group col-md-6 col-lg-3" : "d-none" ?>>
                                                        <label for="select1" class="sottotitolo-articolo">Cartella da condividere</label>
                                                        <select class="selectpicker w-100" name="cartellaDaCondividere" data-live-search="true">
                                                            <option value="1">Cartella radice</option>
                                                            <?php
                                                                $queryNomiTag = "SELECT * FROM geecD_cartelle WHERE  cartellaMadre = 1";
                                                                $risNomi = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                while($cartella = $risNomi->fetch_assoc()) {
                                                                    if(isset($occorrenza) && $occorrenza["cartellaDaCondividere"] == $cartella["id"]) {
                                                                        $selezionato  = "selected";
                                                                    }
                                                                    else {
                                                                        $selezionato  = "";
                                                                    }
                                                                    echo"<option value=\"{$cartella["id"]}\" $selezionato >{$cartella["nome"]}</option>";

                                                                    // per ogni categoria madre vedo le categorie figlie
                                                                    $queryNomiTag = "SELECT * FROM geecD_cartelle WHERE cartellaMadre = {$cartella["id"]}";
                                                                    $risCategoriaFiglia = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                    while($cartellaFiglia = $risCategoriaFiglia->fetch_assoc()) {
                                                                        if(isset($occorrenza) && $occorrenza["cartellaDaCondividere"] == $cartellaFiglia["id"]) {
                                                                            $selezionato  = "selected";
                                                                        }
                                                                        else {
                                                                            $selezionato  = "";
                                                                        }
                                                                        echo"<option value=\"{$cartellaFiglia["id"]}\" $selezionato > - {$cartellaFiglia["nome"]}</option>";
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                    </div>

                                                    <div id="divSelezionaFile" class="<?= ($occorrenza["contenutoDaCondividere"]=="file") ? "form-group col-md-6 col-lg-3" : "d-none" ?>">
                                                        <label for="select1" class="sottotitolo-articolo">Documento da condividere</label>
                                                        <select class="selectpicker w-100" name="fileDaCondividere"  data-live-search="true">
                                                            <option value="0">Seleziona</option>
                                                            <?php
                                                                $queryNomiTag = "SELECT * FROM geecD_documenti";
                                                                $risDocumenti = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                while($documento = $risDocumenti->fetch_assoc()) {
                                                                    if(isset($occorrenza) && $occorrenza["fileDaCondividere"] == $documento["id"]) {
                                                                        $selezionato  = "selected";
                                                                    }
                                                                    else {
                                                                        $selezionato  = "";
                                                                    }
                                                                    echo"<option value=\"{$documento["id"]}\" $selezionato >{$documento["nome"]}</option>";
                                                                }
                                                            ?>
                                                        </select>
                                                    </div>
                                                    
                                                    <div class="col-md-6 form-group">
                                                        <label>Destinatari</label>
                                                        <textarea class="form-control" rows="2" id="nomeSlider" name="destinatari" aria-describedby="nome"><?= ((isset($occorrenza) ? $occorrenza["destinatari"] : "")) ?></textarea>
                                                    </div>
                                                    
                                                    <div class="col-md-6 form-group">
                                                        <label>Testo</label>
                                                        <textarea class="form-control" rows="2" id="nomeSlider" name="testo" aria-describedby="nome"><?= ((isset($occorrenza) ? $occorrenza["testo"] : "")) ?></textarea>
                                                    </div>
                                                    
                                                </div>   
                                            </div><!--/Colonna principale -->
                                        </form>
                                        <!--Colonna secondaria -->
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="button" class="btn btn-primary float-right" onclick="document.formElemento.submit()"><i class="fas fa-check"></i> Salva</button>
                                    </div>
                                </div>
                            </div>
                        
                            </div>
                        </div>
           
                    </form>

                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>
        
        <script>
            function mostraSelectInRelazioneAlContenutoCondiviso() {
                var contenutoDaCondividere = document.getElementById("contenutoDaCondividere").value;
                
                if(contenutoDaCondividere==="file") {
                    document.getElementById("divSelezionaFile").className     = "form-group col-md-6 col-lg-3";
                    document.getElementById("divSelezionaCartella").className = "d-none";
                }
                else {
                    document.getElementById("divSelezionaFile").className     = "d-none";
                    document.getElementById("divSelezionaCartella").className = "form-group col-md-6 col-lg-3";
                }
            }
        </script>

    </body>
</html>
